/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class Fraktal
extends Applet
implements MouseListener,
MouseMotionListener {
    private static final int MAX = 256;
    private static final double SX = -2.025;
    private static final double SY = -1.125;
    private static final double EX = 0.6;
    private static final double EY = 1.125;
    private int x1;
    private int y1;
    private int xs;
    private int ys;
    private int xe;
    private int ye;
    private double xstart;
    private double ystart;
    private double xende;
    private double yende;
    private double xzoom;
    private double yzoom;
    private boolean action;
    private boolean rechteck;
    private boolean fertig;
    private float xy;
    private float klein;
    private Image bild;
    private Graphics g1;
    private Cursor c1;
    private Cursor c2;

    @Override
    public void init() {
        this.fertig = false;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.c1 = new Cursor(3);
        this.c2 = new Cursor(1);
        this.x1 = this.getSize().width;
        this.y1 = this.getSize().height;
        this.xy = (float)this.x1 / (float)this.y1;
        this.bild = this.createImage(this.x1, this.y1);
        this.g1 = this.bild.getGraphics();
        this.klein = 1.0E-7f;
        this.fertig = true;
        this.start();
        this.repaint();
    }

    @Override
    public void destroy() {
        if (this.fertig) {
            this.removeMouseListener(this);
            this.removeMouseMotionListener(this);
            this.bild = null;
            this.g1 = null;
            this.c1 = null;
            this.c2 = null;
        }
    }

    @Override
    public void start() {
        this.action = false;
        this.rechteck = false;
        this.startwerte();
        this.xzoom = (this.xende - this.xstart) / (double)this.x1;
        this.yzoom = (this.yende - this.ystart) / (double)this.y1;
        this.mandelbrot();
    }

    @Override
    public void stop() {
    }

    @Override
    public void paint(Graphics g) {
        this.update(g);
    }

    @Override
    public void update(Graphics g) {
        g.drawImage(this.bild, 0, 0, this);
        if (this.rechteck) {
            g.setColor(Color.white);
            if (this.xs < this.xe) {
                if (this.ys < this.ye) {
                    g.drawRect(this.xs, this.ys, this.xe - this.xs, this.ye - this.ys);
                } else {
                    g.drawRect(this.xs, this.ye, this.xe - this.xs, this.ys - this.ye);
                }
            } else if (this.ys < this.ye) {
                g.drawRect(this.xe, this.ys, this.xs - this.xe, this.ye - this.ys);
            } else {
                g.drawRect(this.xe, this.ye, this.xs - this.xe, this.ys - this.ye);
            }
        }
    }

    private void mandelbrot() {
        float alt = 0.0f;
        this.action = false;
        this.setCursor(this.c1);
        this.showStatus("bitte warten... - please wait...");
        for (int x = 0; x < this.x1; x += 2) {
            for (int y = 0; y < this.y1; ++y) {
                float h = this.punktfarbe(this.xstart + this.xzoom * (double)x, this.ystart + this.yzoom * (double)y);
                if (Math.abs(h - alt) > this.klein) {
                    float b = 1.0f - h * h;
                    this.g1.setColor(Color.getHSBColor(h, 0.8f, b));
                    alt = h;
                }
                this.g1.drawLine(x, y, x + 1, y);
            }
        }
        this.showStatus("Mandelbrotmenge fertig - Mandelbrot Set ready");
        this.setCursor(this.c2);
        this.action = true;
    }

    private float punktfarbe(double xwert, double ywert) {
        int j;
        double r = 0.0;
        double i = 0.0;
        double m = 0.0;
        for (j = 0; j < 256 && m < 4.0; ++j) {
            m = r * r - i * i;
            i = 2.0 * r * i + ywert;
            r = m + xwert;
        }
        return (float)j / 256.0f;
    }

    private void startwerte() {
        this.xstart = -2.025;
        this.ystart = -1.125;
        this.xende = 0.6;
        this.yende = 1.125;
        if (Math.abs((float)((this.xende - this.xstart) / (this.yende - this.ystart)) - this.xy) > this.klein) {
            this.xstart = this.xende - (this.yende - this.ystart) * (double)this.xy;
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        e.consume();
        if (this.action) {
            this.xs = e.getX();
            this.ys = e.getY();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        e.consume();
        if (this.action) {
            int z;
            this.xe = e.getX();
            this.ye = e.getY();
            if (this.xs > this.xe) {
                z = this.xs;
                this.xs = this.xe;
                this.xe = z;
            }
            if (this.ys > this.ye) {
                z = this.ys;
                this.ys = this.ye;
                this.ye = z;
            }
            int w = this.xe - this.xs;
            z = this.ye - this.ys;
            if (w < 2 && z < 2) {
                this.startwerte();
            } else {
                if ((float)w > (float)z * this.xy) {
                    this.ye = (int)((float)this.ys + (float)w / this.xy);
                } else {
                    this.xe = (int)((float)this.xs + (float)z * this.xy);
                }
                this.xende = this.xstart + this.xzoom * (double)this.xe;
                this.yende = this.ystart + this.yzoom * (double)this.ye;
                this.xstart += this.xzoom * (double)this.xs;
                this.ystart += this.yzoom * (double)this.ys;
            }
            this.xzoom = (this.xende - this.xstart) / (double)this.x1;
            this.yzoom = (this.yende - this.ystart) / (double)this.y1;
            this.mandelbrot();
            this.rechteck = false;
            this.repaint();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        e.consume();
        if (this.action) {
            this.xe = e.getX();
            this.ye = e.getY();
            this.rechteck = true;
            this.repaint();
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }
}

