/*
 * Tage.java            14.11.1998
 *
 * Copyright (c) Eckhard Roessel. All Rights Reserved.
 ***************************************************************
 */

import java.applet.Applet;
import java.awt.FontMetrics;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;

/**
 * Tage - Berechnet Anzahl Tage
 *
 * @version 1.1
 * @author Eckhard Roessel
 * @modified 03.02.2014
 */
public class Tage extends Applet {

    private String ausgabe;
    private int x1, x2, y1, y2, t, m, j;
    private FontMetrics fm;
    private GregorianCalendar cal1, cal2;
    private Color rot;
    private Font schrift;

    @Override
    public void init() {
        String tag, monat, jahr;
        setBackground(Color.white);
        x1 = getSize().width;
        y1 = getSize().height;
        y2 = (int) (y1 * 0.72);
        rot = new Color(204, 0, 0);
        schrift = new Font("SanSerif", Font.PLAIN, y2);
        fm = null;
        cal2 = new GregorianCalendar();
        cal1 = new GregorianCalendar();
        // Übernahme aus Parametern
        tag = getParameter("TAG");
        monat = getParameter("MONAT");
        jahr = getParameter("JAHR");
        // Berechnung
        datumeingeben(tag, monat, jahr);
    }

    public void datumeingeben(String t1, String m1, String j1) {
        if (t1.equals("")) {
            t = 28;
        } else {
            t = Integer.parseInt(t1);
        }
        if (m1.equals("")) {
            m = 11;
        } else {
            m = Integer.parseInt(m1);
        }
        if (j1.equals("")) {
            j = 1960;
        } else {
            j = Integer.parseInt(j1);
        }
        if ((t > 0) && (m < 13) && (m > 0) && (((m == 4 || m == 6 || m == 9 || m == 11) && (t < 31)) || (((m != 2 && m != 4 && m != 6 && m != 9 && m != 11 && t < 32))) || ((m == 2) && (((t < 30) && (cal1.isLeapYear(j))) || (t < 29))))) {
            datumsetzen();
            repaint();
        } else {
            ausgabe = "Dieses Datum ist ungültig!";
            repaint();
        }
    }

    public void datumsetzen() {
        ausgabe = "Der ";
        if (t < 10) {
            ausgabe += "0" + t;
        } else {
            ausgabe += t;
        }
        if (m < 10) {
            ausgabe += ".0" + m;
        } else {
            ausgabe += "." + m;
        }
        ausgabe += "." + j + " ";
        m--;
        cal2 = new GregorianCalendar();
        cal1 = new GregorianCalendar();
        cal2.setTimeZone(TimeZone.getTimeZone("ECT"));
        cal1.setTimeZone(TimeZone.getTimeZone("ECT"));
        cal1.setTime(cal1.getTime());
        cal2.setTime(cal2.getTime());
        cal1.setTime(cal2.getTime());
        cal2.setTime(cal1.getTime());
        cal1.setTime(cal1.getTime());
        cal2.setTime(cal2.getTime());
        cal2.set(Calendar.DATE, t);
        cal2.set(Calendar.MONTH, m);
        cal2.set(Calendar.YEAR, j);
        cal2.set(Calendar.HOUR_OF_DAY, 0);
        cal1.set(Calendar.HOUR_OF_DAY, 0);
        cal2.set(Calendar.MINUTE, 0);
        cal1.set(Calendar.MINUTE, 0);
        cal2.set(Calendar.SECOND, 0);
        cal1.set(Calendar.SECOND, 0);
        cal2.setTime(cal2.getTime());
        cal1.setTime(cal1.getTime());
        if (cal1.equals(cal2)) {
            ausgabe += "ist heute.";
        } else {
            t = 0;
            if (cal2.after(cal1)) {
                while (cal2.after(cal1)) {
                    cal1.add(Calendar.DATE, 1);
                    cal1.setTime(cal1.getTime());
                    t++;
                }
                if (t == 1) {
                    ausgabe += "ist morgen.";
                } else {
                    ausgabe += "ist in " + t + " Tagen.";
                }
            } else {
                while (cal1.after(cal2)) {
                    cal2.add(Calendar.DATE, 1);
                    cal2.setTime(cal2.getTime());
                    t++;
                }
                if (t == 1) {
                    ausgabe += "war gestern.";
                } else {
                    ausgabe += "war vor " + t + " Tagen.";
                }
            }
        }
    }

    @Override
    public void destroy() {
        ausgabe = null;
        fm = null;
        cal1 = null;
        cal2 = null;
        schrift = null;
        rot = null;
    }

    @Override
    public void paint(Graphics g) {
        g.setColor(Color.white);
        g.fillRect(0, 0, x1, y1);
        g.setColor(rot);
        g.setFont(schrift);
        fm = g.getFontMetrics();
        x2 = (x1 - fm.stringWidth(ausgabe)) / 2 + 1;
        g.drawString(ausgabe, x2, y2);
    }

    @Override
    public void update(Graphics g) {
        g.setColor(Color.white);
        g.fillRect(0, 0, x1, y1);
        g.setColor(rot);
        g.setFont(schrift);
        fm = g.getFontMetrics();
        x2 = (x1 - fm.stringWidth(ausgabe)) / 2 + 1;
        g.drawString(ausgabe, x2, y2);
    }
}
