/*
 * Farbbox.java                                       09.07.2000
 *
 * Copyright (c) Eckhard Roessel. All Rights Reserved.
 ***************************************************************
 */

import java.applet.Applet;
import java.awt.Color;

/**
 * Farbbox - zeigt eine Farbe an.
 *
 * @version 1.1
 * @author Eckhard Roessel
 * @modified 06.02.2014
 */
public class Farbbox extends Applet {

    @Override
    public void init() {
        this.setBackground(Color.white);
    }

    private Color stringToColor(String Value) {
        int red, green, blue;
        red = (Integer.decode("0x" + Value.substring(0, 2))).intValue();
        green = (Integer.decode("0x" + Value.substring(2, 4))).intValue();
        blue = (Integer.decode("0x" + Value.substring(4, 6))).intValue();
        return new Color(red, green, blue);
    }

    public void eingeben(String eingabe) {
        this.setBackground(stringToColor(eingabe));
        showStatus("Farbcode: #" + eingabe);
        repaint();
    }
}
