/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.util.BitSet;
import java.util.Random;

public class Lotto
extends Applet {
    private int x1;
    private int y1;
    private int x2;
    private int y2;
    private Font schrift;
    private Image bild;
    private Graphics g1;
    private BitSet b;
    private Random r;
    private String aus;

    @Override
    public void init() {
        this.x1 = this.getSize().width;
        this.y1 = this.getSize().height;
        this.x2 = this.x1 / 7;
        this.y2 = this.y1 / 7;
        this.setBackground(Color.white);
        this.schrift = new Font("SanSerif", 1, this.y1 / 10);
        this.bild = this.createImage(this.x1, this.y1);
        this.g1 = this.bild.getGraphics();
        this.r = new Random();
        this.b = new BitSet();
        this.neu();
    }

    @Override
    public void destroy() {
        this.schrift = null;
        this.bild = null;
        this.r = null;
        this.b = null;
        this.aus = null;
    }

    public void neu() {
        this.aus = "Lottotipp:";
        this.b.clear();
        int n = 0;
        do {
            int m;
            if (this.b.get(m = this.zufall())) continue;
            this.b.set(m);
            ++n;
        } while (n < 6);
        this.tipp();
    }

    public int zufall() {
        long l = this.r.nextLong();
        this.r.setSeed(l);
        int z = 1 + this.r.nextInt(49);
        return z;
    }

    public void tipp() {
        int feld;
        int zahl;
        this.g1.setColor(Color.white);
        this.g1.fillRect(0, 0, this.x1, this.y1);
        this.g1.setColor(Color.red);
        this.g1.setFont(this.schrift);
        for (zahl = 1; zahl < 7; ++zahl) {
            this.g1.drawLine(0, this.y2 * zahl, this.x1, this.y2 * zahl);
            this.g1.drawLine(this.x2 * zahl, 0, this.x2 * zahl, this.y1);
        }
        for (zahl = 0; zahl < 3; ++zahl) {
            this.g1.drawRect(zahl, zahl, this.x1 - zahl * 2 - 1, this.y1 - zahl * 2 - 1);
        }
        for (feld = 0; feld < 9; ++feld) {
            this.g1.drawString("" + (feld + 1), feld % 7 * this.x2 + this.x2 / 3, feld / 7 * this.y2 + this.y1 / 9);
        }
        for (feld = 9; feld < 49; ++feld) {
            this.g1.drawString("" + (feld + 1), feld % 7 * this.x2 + this.x2 / 5, feld / 7 * this.y2 + this.y1 / 9);
        }
        this.g1.setColor(Color.black);
        int n = 0;
        for (feld = 0; feld < 49 && n < 6; ++feld) {
            if (!this.b.get(feld + 1)) continue;
            ++n;
            this.b.clear(feld + 1);
            this.aus = this.aus + " " + (feld + 1);
            int x = feld % 7 * this.x2;
            int y = feld / 7 * this.y2;
            int x3 = x + this.x2;
            int y3 = y + this.y2;
            this.g1.drawLine(x, y, x3, y3);
            this.g1.drawLine(x + 1, y, x3, y3 - 1);
            this.g1.drawLine(x, y + 1, x3 - 1, y3);
            this.g1.drawLine(x, y3, x3, y);
            this.g1.drawLine(x, y3 - 1, x3 - 1, y);
            this.g1.drawLine(x + 1, y3, x3, y + 1);
        }
        this.repaint();
    }

    @Override
    public void paint(Graphics g) {
        this.setBackground(Color.white);
        this.showStatus(this.aus);
        g.drawImage(this.bild, 0, 0, this);
    }

    @Override
    public void update(Graphics g) {
        this.setBackground(Color.white);
        this.showStatus(this.aus);
        g.drawImage(this.bild, 0, 0, this);
    }
}

