/*
 * Lotto.java                                         07.04.2000
 *
 * Copyright (c) Eckhard Roessel. All Rights Reserved.
 ***************************************************************
 */

import java.applet.Applet;
import java.awt.Graphics;
import java.awt.Font;
import java.awt.Image;
import java.awt.Color;
import java.util.Random;
import java.util.BitSet;

/**
 * Lotto - zufällige Lottozahlen
 *
 * @version 1.1
 * @author Eckhard Roessel
 * @modified 07.04.2000
 * @modified 06.02.2014
 */
public class Lotto extends Applet {

    private int x1, y1, x2, y2;
    private Font schrift;
    private Image bild;
    private Graphics g1;
    private BitSet b;
    private Random r;
    private String aus;

    @Override
    public void init() {
        x1 = getSize().width;
        y1 = getSize().height;
        x2 = x1 / 7;
        y2 = y1 / 7;
        setBackground(Color.white);
        schrift = new Font("SanSerif", Font.BOLD, y1 / 10);
        bild = createImage(x1, y1);
        g1 = bild.getGraphics();
        r = new Random();
        b = new BitSet();
        neu();
    }

    @Override
    public void destroy() {
        schrift = null;
        bild = null;
        r = null;
        b = null;
        aus = null;
    }

    public void neu() {    // 6 Zufallszahlen setzen Bits in einem Bitfeld.
        int n, m;
        aus = "Lottotipp:";
        b.clear();
        n = 0;
        do {
            m = zufall();
            if (!b.get(m)) {
                b.set(m);
                n++;
            }
        } while (n < 6);
        tipp();
    }

    public int zufall() {   // erzeugt eine zufällige Int-Zahl von 1 bis 49.
        int z;
        long l;
        l = r.nextLong();
        r.setSeed(l);
        z = 1 + r.nextInt(49);
        return z;
    }

    public void tipp() {   // gibt den Lottotipp grafisch aus.
        int x, y, x3, y3, n, feld, zahl;
        g1.setColor(Color.white);
        g1.fillRect(0, 0, x1, y1);
        g1.setColor(Color.red);
        g1.setFont(schrift);
        for (zahl = 1; zahl < 7; zahl++) {
            g1.drawLine(0, y2 * zahl, x1, y2 * zahl);
            g1.drawLine(x2 * zahl, 0, x2 * zahl, y1);
        }
        for (zahl = 0; zahl < 3; zahl++) {
            g1.drawRect(zahl, zahl, x1 - zahl * 2 - 1, y1 - zahl * 2 - 1);
        }
        for (feld = 0; feld < 9; feld++) {
            g1.drawString("" + (feld + 1), ((feld % 7) * x2 + x2 / 3), ((feld / 7) * y2 + y1 / 9));
        }
        for (feld = 9; feld < 49; feld++) {
            g1.drawString("" + (feld + 1), ((feld % 7) * x2 + x2 / 5), ((feld / 7) * y2 + y1 / 9));
        }
        g1.setColor(Color.black);
        n = 0;
        for (feld = 0; ((feld < 49) && (n < 6)); feld++) {
            if (b.get(feld + 1)) {
                n++;
                b.clear(feld + 1);
                aus += " " + (feld + 1);
                x = (feld % 7) * x2;
                y = (feld / 7) * y2;
                x3 = x + x2;
                y3 = y + y2;
                g1.drawLine(x, y, x3, y3);
                g1.drawLine(x + 1, y, x3, y3 - 1);
                g1.drawLine(x, y + 1, x3 - 1, y3);
                g1.drawLine(x, y3, x3, y);
                g1.drawLine(x, y3 - 1, x3 - 1, y);
                g1.drawLine(x + 1, y3, x3, y + 1);
            }
        }
        repaint();
    }

    @Override
    public void paint(Graphics g) {
        setBackground(Color.white);
        showStatus(aus);
        g.drawImage(bild, 0, 0, this);
    }

    @Override
    public void update(Graphics g) {
        setBackground(Color.white);
        showStatus(aus);
        g.drawImage(bild, 0, 0, this);
    }
}
